// REAL DEVICE CSS OVERRIDE SOLUTION
(function() {
    'use strict';

    function forceStylesToMobile() {
        var isMobile = window.innerWidth <= 1024 || /Android|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini|Samsung/i.test(navigator.userAgent);

        if (isMobile) {
            // Container force styling
            var containers = document.querySelectorAll('.dwd-grid-container');
            containers.forEach(function(container) {
                container.setAttribute('style',
                    'display: block !important; ' +
                    'width: 100% !important; ' +
                    'max-width: 100% !important; ' +
                    'grid-template-columns: none !important; ' +
                    'grid: none !important; ' +
                    'margin: 15px auto !important; ' +
                    'box-sizing: border-box !important;'
                );
            });

            // Items force styling
            var items = document.querySelectorAll('.dwd-grid-item');
            items.forEach(function(item) {
                item.setAttribute('style',
                    (item.getAttribute('style') || '').replace(/grid-column:[^;]*;/g, '') +
                    'display: block !important; ' +
                    'width: 100% !important; ' +
                    'max-width: 100% !important; ' +
                    'grid-column: initial !important; ' +
                    'grid-row: initial !important; ' +
                    'float: none !important; ' +
                    'margin: 0 auto ' + dwdMasonryVars.gap_px + 'px auto !important; ' +
                    'box-sizing: border-box !important;'
                );
            });

            // Force reflow
            setTimeout(function() {
                document.body.style.display = 'none';
                document.body.offsetHeight;
                document.body.style.display = '';
            }, 50);

            setTimeout(function() {
                containers.forEach(function(container) {
                    container.style.display = 'none';
                    container.offsetHeight;
                    container.style.display = 'block';
                });
            }, 100);
        }
    }

    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', forceStylesToMobile);
    } else {
        forceStylesToMobile();
    }

    window.addEventListener('resize', forceStylesToMobile);
    window.addEventListener('orientationchange', function() {
        setTimeout(forceStylesToMobile, 200);
    });

    document.documentElement.setAttribute('data-dwd-version', Date.now());
})();